/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import noppes.npcs.LogWriter;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IEntityDamageSource;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IRayTrace;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.EntityType;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.mixin.entity.IEntityMixin;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.RayTraceWrapper;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.api.wrapper.data.Data;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.util.Util;

public class EntityWrapper<T extends Entity>
implements IEntity {
    protected T entity;
    protected final Data storeddata;
    protected final Data tempdata = new Data();
    private IWorld worldWrapper;

    public static List<Entity> findEntityOnPath(Entity entity, double distance, Vec3d vec3d, Vec3d vec3d1) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity entity1 : Util.instance.getEntitiesWithinDist(Entity.class, entity.field_70170_p, entity, distance)) {
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            if (!entity1.func_70067_L() || entity1 == entity || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y())).func_72327_a(vec3d, vec3d1)) == null) continue;
            result.add(entity1);
        }
        result.sort((o1, o2) -> {
            double d2;
            double d1 = entity.func_70032_d(o1);
            if (d1 == (d2 = (double)entity.func_70032_d(o2))) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        });
        return result;
    }

    public static IEntity[] findIEntityOnPath(Entity entity, double distance, Vec3d vec3d, Vec3d vec3d1) {
        ArrayList result = new ArrayList();
        for (Entity e : EntityWrapper.findEntityOnPath(entity, distance, vec3d, vec3d1)) {
            result.add(Objects.requireNonNull(NpcAPI.Instance()).getIEntity(e));
        }
        return result.toArray(new IEntity[0]);
    }

    public EntityWrapper(T entityIn) {
        this.entity = entityIn;
        this.storeddata = entityIn instanceof EntityPlayer ? PlayerData.get((EntityPlayer)((EntityPlayer)entityIn)).scriptStoreddata : ((IEntityMixin)entityIn).npcs$getStoredData();
        this.resetWorld();
    }

    private void resetWorld() {
        if (((Entity)this.entity).field_70170_p instanceof WorldServer) {
            this.worldWrapper = Objects.requireNonNull(NpcAPI.Instance()).getIWorld(((Entity)this.entity).field_70170_p);
        } else if (((Entity)this.entity).field_70170_p != null) {
            WorldWrapper w = (WorldWrapper)WrapperNpcAPI.worldCache.get(((Entity)this.entity).field_70170_p.field_73011_w.getDimension());
            if (w != null) {
                if (w.world == null) {
                    w.world = ((Entity)this.entity).field_70170_p;
                }
            } else {
                w = WorldWrapper.createNew(((Entity)this.entity).field_70170_p);
                WrapperNpcAPI.worldCache.put(((Entity)this.entity).field_70170_p.field_73011_w.getDimension(), w);
            }
            this.worldWrapper = w;
        }
    }

    public void addRider(IEntity entity) {
        if (entity != null) {
            entity.getMCEntity().func_184205_a(this.entity, true);
        }
    }

    @Override
    public void addTag(String tag) {
        this.entity.func_184211_a(tag);
    }

    @Override
    public void clearRiders() {
        this.entity.func_184226_ay();
    }

    @Override
    public void damage(float amount) {
        this.entity.func_70097_a(DamageSource.field_76377_j, amount);
    }

    @Override
    public void damage(float amount, IEntityDamageSource source) {
        if (!(this.entity instanceof EntityLivingBase)) {
            return;
        }
        if (source instanceof EntityDamageSource) {
            this.entity.func_70097_a((DamageSource)source, amount);
            if (((EntityDamageSource)source).func_76346_g() instanceof EntityLivingBase) {
                if (this.entity instanceof EntityLiving) {
                    ((EntityLiving)this.entity).func_70624_b((EntityLivingBase)((EntityDamageSource)source).func_76346_g());
                }
                if (this.entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)this.entity).func_70604_c((EntityLivingBase)((EntityDamageSource)source).func_76346_g());
                }
            }
        } else {
            this.damage(amount);
        }
    }

    @Override
    public void despawn() {
        ((Entity)this.entity).field_70128_L = true;
    }

    public IEntityItem dropItem(IItemStack item) {
        return (IEntityItem)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.entity.func_70099_a(item.getMCItemStack(), 0.0f));
    }

    @Override
    public void extinguish() {
        this.entity.func_70066_B();
    }

    @Override
    public String generateNewUUID() {
        UUID id = UUID.randomUUID();
        this.entity.func_184221_a(id);
        return id.toString();
    }

    @Override
    public long getAge() {
        return ((Entity)this.entity).field_70173_aa;
    }

    public IEntity[] getAllRiders() {
        ArrayList list = new ArrayList(this.entity.func_184182_bu());
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public int getBlockX() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70165_t);
    }

    @Override
    public int getBlockY() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70163_u);
    }

    @Override
    public int getBlockZ() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70161_v);
    }

    @Override
    public String getEntityName() {
        String s = EntityList.func_75621_b(this.entity);
        if (s == null) {
            s = "generic";
        }
        return new TextComponentTranslation("entity." + s + ".name", new Object[0]).func_150254_d();
    }

    @Override
    public INbt getEntityNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        this.entity.func_189511_e(compound);
        ResourceLocation resourcelocation = EntityList.func_191301_a(this.entity);
        if (this.getType() == 1) {
            resourcelocation = new ResourceLocation("player");
        }
        if (resourcelocation != null) {
            compound.func_74778_a("id", resourcelocation.toString());
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(compound);
    }

    @Override
    public float getEyeHeight() {
        return this.entity.func_70047_e();
    }

    @Override
    public float getHeight() {
        return ((Entity)this.entity).field_70131_O;
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    @Override
    public double getMotionX() {
        return ((Entity)this.entity).field_70159_w;
    }

    @Override
    public double getMotionY() {
        return ((Entity)this.entity).field_70181_x;
    }

    @Override
    public double getMotionZ() {
        return ((Entity)this.entity).field_70179_y;
    }

    public IEntity getMount() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIEntity(this.entity.func_184187_bx());
    }

    @Override
    public String getName() {
        return this.entity.func_70005_c_();
    }

    @Override
    public INbt getNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.entity.getEntityData());
    }

    @Override
    public float getPitch() {
        return ((Entity)this.entity).field_70125_A;
    }

    @Override
    public IPos getPos() {
        return new BlockPosWrapper(((Entity)this.entity).field_70165_t, ((Entity)this.entity).field_70163_u, ((Entity)this.entity).field_70161_v);
    }

    public IEntity[] getRiders() {
        List list = this.entity.func_184188_bt();
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public float getRotation() {
        return ((Entity)this.entity).field_70177_z;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public String[] getTags() {
        return this.entity.func_184216_O().toArray(new String[0]);
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public int getType() {
        return EntityType.UNKNOWN.get();
    }

    @Override
    public String getTypeName() {
        return EntityList.func_75621_b(this.entity);
    }

    @Override
    public String getUUID() {
        return this.entity.func_110124_au().toString();
    }

    @Override
    public float getWidth() {
        return ((Entity)this.entity).field_70130_N;
    }

    @Override
    public IWorld getWorld() {
        if (this.worldWrapper == null || ((Entity)this.entity).field_70170_p != this.worldWrapper.getMCWorld()) {
            this.resetWorld();
        }
        return this.worldWrapper;
    }

    @Override
    public double getX() {
        return ((Entity)this.entity).field_70165_t;
    }

    @Override
    public double getY() {
        return ((Entity)this.entity).field_70163_u;
    }

    @Override
    public double getZ() {
        return ((Entity)this.entity).field_70161_v;
    }

    @Override
    public boolean hasCustomName() {
        return this.entity.func_145818_k_();
    }

    @Override
    public boolean hasTag(String tag) {
        return this.entity.func_184216_O().contains(tag);
    }

    @Override
    public boolean inFire() {
        return this.entity.func_70055_a(Material.field_151581_o);
    }

    @Override
    public boolean inLava() {
        return this.entity.func_70055_a(Material.field_151587_i);
    }

    @Override
    public boolean inWater() {
        return this.entity.func_70055_a(Material.field_151586_h);
    }

    @Override
    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public void kill() {
        this.entity.func_70106_y();
    }

    @Override
    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.func_70024_g((double)(-MathHelper.func_76126_a((float)v) * (float)power), 0.1 + (double)((float)power * 0.04f), (double)(MathHelper.func_76134_b((float)v) * (float)power));
        T entity = this.entity;
        ((Entity)entity).field_70159_w *= 0.6;
        T entity2 = this.entity;
        ((Entity)entity2).field_70179_y *= 0.6;
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void playAnimation(int type) {
        if (!(this.worldWrapper.getMCWorld() instanceof WorldServer)) {
            return;
        }
        ((WorldServer)this.worldWrapper.getMCWorld()).func_73039_n().func_151248_b(this.entity, (Packet)new SPacketAnimation(this.entity, type));
    }

    @Override
    public IRayTrace rayTraceBlock(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vec3d vec3d = this.entity.func_174824_e(1.0f);
        Vec3d vec3d2 = this.entity.func_70676_i(1.0f);
        Vec3d vec3d3 = vec3d.func_72441_c(vec3d2.field_72450_a * distance, vec3d2.field_72448_b * distance, vec3d2.field_72449_c * distance);
        RayTraceResult result = ((Entity)this.entity).field_70170_p.func_147447_a(vec3d, vec3d3, stopOnLiquid, ignoreBlockWithoutBoundingBox, true);
        if (result == null) {
            return null;
        }
        return new RayTraceWrapper(Objects.requireNonNull(NpcAPI.Instance()).getIBlock(((Entity)this.entity).field_70170_p, result.func_178782_a()), result.field_178784_b.func_176745_a());
    }

    public IEntity[] rayTraceEntities(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vec3d vec3d = this.entity.func_174824_e(1.0f);
        Vec3d vec3d2 = this.entity.func_70676_i(1.0f);
        Vec3d vec3d3 = vec3d.func_72441_c(vec3d2.field_72450_a * distance, vec3d2.field_72448_b * distance, vec3d2.field_72449_c * distance);
        RayTraceResult result = ((Entity)this.entity).field_70170_p.func_147447_a(vec3d, vec3d3, stopOnLiquid, ignoreBlockWithoutBoundingBox, false);
        if (result != null) {
            vec3d3 = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
        }
        return EntityWrapper.findIEntityOnPath(this.entity, distance, vec3d, vec3d3);
    }

    @Override
    public void removeTag(String tag) {
        this.entity.func_184197_b(tag);
    }

    @Override
    public void setBurning(int ticks) {
        this.entity.func_70015_d(ticks);
    }

    @Override
    public void setEntityNbt(INbt nbt) {
        this.entity.func_70020_e(nbt.getMCNBT());
    }

    @Override
    public void setMotionX(double motion) {
        if (((Entity)this.entity).field_70159_w == motion) {
            return;
        }
        ((Entity)this.entity).field_70159_w = motion;
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void setMotionY(double motion) {
        if (((Entity)this.entity).field_70181_x == motion) {
            return;
        }
        ((Entity)this.entity).field_70181_x = motion;
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void setMotionZ(double motion) {
        if (((Entity)this.entity).field_70179_y == motion) {
            return;
        }
        ((Entity)this.entity).field_70179_y = motion;
        ((Entity)this.entity).field_70133_I = true;
    }

    public void setMount(IEntity entity) {
        if (entity == null) {
            this.entity.func_184210_p();
        } else {
            this.entity.func_184205_a(entity.getMCEntity(), true);
        }
    }

    @Override
    public void setName(String name) {
        this.entity.func_96094_a(name);
    }

    @Override
    public void setPitch(float rotation) {
        ((Entity)this.entity).field_70125_A = rotation;
    }

    @Override
    public void setPos(IPos pos) {
        this.entity.func_70107_b(pos.getX() + 0.5, pos.getY(), pos.getZ() + 0.5);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        if (this.entity instanceof EntityPlayerMP) {
            this.entity.func_70080_a(x, y, z, ((Entity)this.entity).field_70177_z, ((Entity)this.entity).field_70125_A);
        } else {
            this.entity.func_70107_b(x, y, z);
        }
    }

    @Override
    public void setRotation(float rotation) {
        ((Entity)this.entity).field_70177_z = rotation % 360.0f;
    }

    @Override
    public void setX(double x) {
        ((Entity)this.entity).field_70165_t = x;
    }

    @Override
    public void setY(double y) {
        ((Entity)this.entity).field_70163_u = y;
    }

    @Override
    public void setZ(double z) {
        ((Entity)this.entity).field_70161_v = z;
    }

    @Override
    public void spawn() {
        if (this.worldWrapper.getMCWorld().field_72995_K) {
            return;
        }
        LogWriter.debug("Try summoning 0: " + this.entity.func_70005_c_() + "; UUID: " + this.entity.func_110124_au());
        Entity el = null;
        try {
            for (Entity e : this.worldWrapper.getMCWorld().field_72996_f) {
                if (!e.func_110124_au().equals(this.entity.func_110124_au())) continue;
                el = e;
                break;
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        if (el != null) {
            LogWriter.debug("Error summoning: " + this.entity.func_70005_c_());
            throw new CustomNPCsException("Entity is already spawned", new Object[0]);
        }
        ((Entity)this.entity).field_70128_L = false;
        LogWriter.debug("Try summoning 1: " + this.entity.func_70005_c_());
        try {
            boolean bo = this.worldWrapper.getMCWorld().func_72838_d(this.entity);
            LogWriter.debug("Is summoning: " + bo + "; World: " + ((Entity)this.entity).field_70170_p.getClass().getSimpleName());
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public void storeAsClone(int tab, String name) {
        NBTTagCompound compound = new NBTTagCompound();
        if (!this.entity.func_184198_c(compound)) {
            throw new CustomNPCsException("Cannot store dead entities", new Object[0]);
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
    }

    @Override
    public boolean typeOf(int type) {
        return type == this.getType();
    }
}

